//
//  GSSidebarItem.h
//  Glyphs 3
//
//  Created by Georg Seifert on 16.03.20.
//  Copyright © 2020 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>

extern NSString *_Nonnull GSFilterPredicateImageName;
extern NSString *_Nonnull GSFilterListImageName;
extern NSString *_Nonnull GSFilterFolderImageName;

typedef NS_ENUM(int8_t, GSSidebarItemType) {
	GSSidebarItemTypeUndefined,
	GSSidebarItemTypeCategory,
	GSSidebarItemTypeLanguage,
	GSSidebarItemTypeFilter,
};

@class GSFont;
@class GSGlyphsInfo;
@class GSGlyphInfo;

NS_ASSUME_NONNULL_BEGIN

@interface GSSidebarItem : NSObject <NSCopying>

@property (nonatomic, weak) GSFont *font;
@property (unsafe_unretained) GSSidebarItem *parent;

@property (readonly, nonatomic, nullable) NSImage *icon;
@property (strong, nullable) NSString *iconName;
@property (strong) NSString *name;
@property (strong, nonatomic) NSString *displayName;
@property (strong) NSString *identifier;
@property (strong) NSString *unicharString;
@property (readonly, nullable) NSString *badgeString;
@property (readonly) NSArray<GSGlyphInfo *> *missingInfos;

@property (nonatomic, assign) BOOL editable;

@property (nonatomic, assign) BOOL hidden;

@property (strong, nullable) NSPredicate *predicate;
@property (strong, nonatomic, nullable) NSArray<NSString *> *coverage;
@property (readonly, nullable) NSArray<GSGlyphInfo *> *nameList;

@property (nonatomic, strong) NSMutableArray<GSSidebarItem *> *subItems;
- (void)insertObject:(GSSidebarItem *)object inSubItemsAtIndex:(NSUInteger)idx;
- (void)insertSubItems:(NSArray<GSSidebarItem *> *)array atIndex:(NSUInteger)idx;
- (void)removeSubItemsObject:(GSSidebarItem *)object;

@property (readonly) BOOL isLeaf;

@property (assign) BOOL isCalculating;
@property (nonatomic, readonly) BOOL hasShallHaveCount;
@property (nonatomic, readonly) BOOL badgeVisible;
@property (nonatomic, readonly) NSInteger count;
@property (nonatomic, readonly) NSInteger shallHaveCount;
@property (nonatomic, strong) NSString *filePath;

@property (nonatomic, assign) BOOL canAdd;

@property (nonatomic, readonly) NSString *hiddenKey;

@property (nonatomic, assign) GSSidebarItemType itemType;

// helper field for the New Document dialog.
@property (nonatomic, assign) BOOL active;
@property (nonatomic, assign) BOOL preset;

- (instancetype)initWithDict:(NSDictionary *)dict;

- (void)expandNameList:(GSGlyphsInfo *)glyphsInfo;

- (void)resetCounter;

@end

NS_ASSUME_NONNULL_END
